#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=vga-port-cable-plug-video_108643.ico
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#include <TrayConstants.au3>
#include <CommUtilities.au3>
#include <GUIConstantsEx.au3>
#include "SysPortListCOM_GUI.au3"
#include <Array.au3>

Opt("TrayMenuMode", 3) ; Ręczna obsługa menu + można odznaczać
;Opt("TrayOnEventMode", 1) ; Włącz obsługę zdarzeń tray
Global $sysTick				= 0
Global $sysWait				= 2 * 10000000				; 5 seconds (5*1000000us)

Global $comPorts

Global $idDynamic 			= TrayCreateItem("Lista portów COM")
Global $idExit 				= TrayCreateItem("Wyjście")




TraySetToolTip("Dynamiczne menu")

TraySetState()

Func SysWait($wait_us)
	$newTick = TimerInit()
	If $sysTick + $wait_us < $newTick Then
		$sysTick = $newTick
		Local $ports = _CommAPI_GetCOMPorts()
		if $comPorts <> $ports Then
			;ConsoleWrite("---- "&&" ----")
			If StringLen($comPorts)<StringLen($ports) Then
				TrayTip("Dodano port COM", GetDifference($ports, $comPorts), 1)
			Else
				TrayTip("Usunięto port COM", GetDifference($comPorts, $ports),1)
			EndIf
			GUICtrlSetData($lstComPorts, "")
			$comPorts = $ports
			$ports = StringReplace($ports, @CRLF, "|")
			GUICtrlSetData($lstComPorts, $ports)
		EndIf
	EndIf
EndFunc

Func GetDifference($sList1, $sList2)
    Local $aList1 = StringSplit($sList1, @CRLF, $STR_NOCOUNT)
    Local $aList2 = StringSplit($sList2, @CRLF, $STR_NOCOUNT)
    Local $sDiff = ""
    For $i = 0 To UBound($aList1) - 1
        If _ArraySearch($aList2, $aList1[$i]) = -1 Then $sDiff &= $aList1[$i] & @CRLF
    Next
    Return StringStripWS($sDiff, 3)
EndFunc


While 1

	;$fff = _CommAPI_GetCOMPorts()
	SysWait($sysWait)
    Switch TrayGetMsg()
        Case $idDynamic
			#MsgBox(0, "", _CommAPI_GetCOMPorts())
            GUISetState(@SW_SHOW, $hGUI)
			GUISetState(@SW_RESTORE, $hGUI)

        Case $idExit
			$exitCode = MsgBox(4, "Wyjście", "Czy zakończyć program?")
			ConsoleWrite("------ EXIT CODE: " & $exitCode & " -------" & @CRLF)
			If $exitCode = 6 Then Exit
	EndSwitch
    Switch GUIGetMsg()
        Case $GUI_EVENT_CLOSE, $GUI_EVENT_MINIMIZE
            GUISetState(@SW_HIDE, $hGUI) ; Zamiast zamykać, ukryj okno
    EndSwitch
WEnd